''//////////////////////////////////////////////////////////////////////////////
'' Defender Remake                                                        
'' (C) Steve Waddicor 2007
''
'' Included EPM_Defender_Sound_Engine* files (C) Eric Moyer 2007
''
'' This program is a free as in beer for download from the Parallax web forums.
'' Distribution through any other website, CD or any other distribution medium
'' only by prior permission from the authors.
''//////////////////////////////////////////////////////////////////////////////

OBJ
    c      : "sw_df_customise_003"
    g      : "sw_df_globals_006"
    tv     : "sw_df_tv_drv_009"
    gfx    : "sw_df_gfx_011"
    p_rend : "sw_df_gfx_renderer_012"
    s_rend : "sw_df_scanner_renderer_007"
    t_rend : "sw_df_tile_renderer_001"
    sfx1   : "EPM_Defender_Sound_Engine1_030.spin"
    sfx2   : "EPM_Defender_Sound_Engine2_005.spin"
    key    : "comboKeyboard"
    uart   : "FullDuplex.spin"

CON
'uncomment the '{ block which suites your system.

{ Hybrid Defines
        _CLKMODE                = xtal1 + pll16x
        _XINFREQ                = 6_000_000 + 0000
USE_TV_ON_PIN_24                = 1      ' usually 0 for Proto/Demo boards and 1 for Hydra
USE_KEYBOARD                    = 1
KEYSPIN                         = 12 
HARDWARE                        = sfx1#HARDWARE_HYBRID
' NES bit encodings for NES gamepad 0
GP_RIGHT  = %00000000_00001000
GP_LEFT   = %00000000_00000100
GP_DOWN   = %00000000_00000010
GP_UP     = %00000000_00000001
GP_START  = %00000000_00100000
GP_SELECT = %00000000_00100000
GP_B      = %00000000_10000000
GP_A      = %00000000_10000000
'}
{ Hydra Defines
        _CLKMODE                = xtal1 + pll8x
        _XINFREQ                = 10_000_000 + 0000
USE_TV_ON_PIN_24                = 1      ' usually 0 for Proto/Demo boards and 1 for Hydra
USE_KEYBOARD                    = 0
KEYSPIN                         = 13
HARDWARE                        = sfx1#HARDWARE_HYDRA 
' NES bit encodings for NES gamepad 0
GP_RIGHT  = %00000000_00000001
GP_LEFT   = %00000000_00000010
GP_DOWN   = %00000000_00000100
GP_UP     = %00000000_00001000
GP_START  = %00000000_00010000
GP_SELECT = %00000000_00100000
GP_B      = %00000000_01000000
GP_A      = %00000000_10000000
'}
'{ Proto/Demoboard Defines
        _CLKMODE                = xtal1 + pll16x
        _XINFREQ                = 5_000_000 + 0000
USE_TV_ON_PIN_24                = 0      ' usually 0 for Proto/Demo boards and 1 for Hydra 
USE_KEYBOARD                    = 1
KEYSPIN                         = 26 
HARDWARE                        = sfx1#HARDWARE_HYDRA 
' NES bit encodings for NES gamepad 0
GP_RIGHT  = %00000000_00000001
GP_LEFT   = %00000000_00000010
GP_DOWN   = %00000000_00000100
GP_UP     = %00000000_00001000
GP_START  = %00000000_00010000
GP_SELECT = %00000000_00100000
GP_B      = %00000000_01000000
GP_A      = %00000000_10000000
'}

CON
    _stack = 76
    PLAYFIELD_RENDER_COGS       = 4     
    SCANNER_RENDER_COGS         = 1
    TERRAIN_COLOR               = $6c
    INVISIBLE_LOCATION          = -1

CON
    SPRITE_XPOS                 = 0
    SPRITE_YPOS                 = 1
    SPRITE_INVISIBLE            = %1000_0000_0000_0000

CON
    #0
    GAME_TITLE_INIT
    GAME_POST
    GAME_TITLE
    GAME_START
    GAME_DISPLAY_PLAYER_INIT
    GAME_DISPLAY_PLAYER
    GAME_LEVEL_INIT
    GAME_LEVEL
    GAME_LEVEL_COMPLETED_INIT
    GAME_LEVEL_COMPLETED
    GAME_OVER_INIT
    GAME_OVER

CON
    #0
    STATE_NOT_DEPLOYED
    STATE_DEAD
    STATE_BONUS

    STATE_LANDER_APPEARING
    STATE_BOMBER_APPEARING
    STATE_POD_APPEARING
    STATE_BAITER_APPEARING
    STATE_DYING

    STATE_LIVE_STATES
    
    STATE_HUMANOID_MOVEMENT
    STATE_HUMANOID_TARGETED
    STATE_HUMANOID_ASCENDING
    STATE_HUMANOID_FALLING
    STATE_HUMANOID_HANGING
    STATE_LANDER_MOVEMENT
    STATE_LANDER_TARGETED
    STATE_LANDER_ASCENDING
    STATE_MUTANT_MOVEMENT
    STATE_BOMBER_MOVEMENT
    STATE_POD_MOVEMENT
    STATE_SWARMER_MOVEMENT
    STATE_BAITER_MOVEMENT

VAR
    ' Renderer parameter block
    ' Each renderer copies these values to it's own cog_memory cache
    ' when it's got a little spare time, several times per frame
    ' so these values can be altered on the fly.
    long    rend_cog_number        'each cog gets a different number, starting with zero     write-only
    long    rend_playfield_cog_count         'total number of cogs                                     write-only
    long    rend_scanner_cog_count
    long    rend_scanline_req_adr  'a pointer to the request to put a line in the scan buffer   write-only
    long    rend_sprite_def_ptr    'pointer to tile definitions (longs)                      write-only
    long    rend_character_table_ptr
    long    rend_laser_def_ptr
    long    rend_palette_ptr       'pointer to colors (longs)                               write-only
    long    rend_tile_map_ptr
    long    rend_scanline_buffer_adr 'hub memory where renderer puts scanline when requested write-only
    long    rend_terrain_ptr
    long    rend_terrain_color
    long    rend_side_scroll                            'position of screen left in pixels (wraps at 1024)
    long    rend_bcd_score                              'score in binary coded decimal
    long    rend_sprite_locs[g#NUMBER_OF_SPRITES]       '%i.YYYYYY_YYyyyyyy_XXXXXXXX_XXxxxxxx (negative = invisible)
    long    rend_sprite_tiles[g#NUMBER_OF_SPRITES]      '%........_EEEEEEEE_........_TTTTTTTT (E = explode count, T = tile number)
    long    rend_lasers[g#NUMBER_OF_LASER_SHOTS]        '%.......R_NNNNNNNN_XXXXXXXX_YYYYYYYY (N = state_count, Y = scan line, R= reverse)
    long    rend_bullets[g#NUMBER_OF_BULLETS]           '%i.YYYYYY_YYyyyyyy_XXXXXXXX_XXxxxxxx (negative = invisible)
    long    rend_palette[g#NUMBER_OF_COLORS]
                               
    'End of renderer parameter block

VAR
    ' TV driver parameter block
    long    tv_scanline_request_adr
    long    tv_scanline_buffer_adr
    long    tv_use_tv_on_pin24
    long    tv_status
    ' End of TV parameter block

VAR
    long    startkey
    long    selectkey
    long    debug

VAR
    byte    game_state
    byte    player_level[2]
    byte    player_lives[2]
    byte    game_player_up
    byte    game_continue_life
    long    mutant_color

    long    game_two_players
    long    player_score[2]
    long    hi_score
    long    gp
    long    game_state_count
    long    timer
    long    timer_state_count
    long    rnd

    ' New for Defender
    long    player_x_velocity
    long    player_y_velocity
    long    player_h_direction
    long    player_v_direction
    long    target_player_position
    long    player_position
    long    explode_count
    long    explode_state_count
    long    x_velocity[g#NUMBER_OF_SPRITES]
    long    y_velocity[g#NUMBER_OF_SPRITES]
    long    sprite_state[g#NUMBER_OF_SPRITES]
    long    sprite_state_count[g#NUMBER_OF_SPRITES]
    long    sprite_onscreen[g#NUMBER_OF_SPRITES]
    long    target[g#NUMBER_OF_SPRITES]
    long    bullet_velocity_x[g#NUMBER_OF_BULLETS]
    long    bullet_velocity_y[g#NUMBER_OF_BULLETS]
    long    bullet_time_to_live[g#NUMBER_OF_BULLETS]
    long    cog_numbers[PLAYFIELD_RENDER_COGS]
    long    laser_state_count
    long    fire_button_up
    long    reverse_button_up
    long    frame_count
    long    color_count
    long    humanoids_alive
    long    planet_exploded
    long    score
    long    anim_count
    long    waddicors_tile_num
    long    waddicors_draw_list
    long    waddicors_next_frame

    'Sound control block
    long    sfx_command                 ' Sound effects command
    long    thrust_command              ' Thrust command
    long    sfx_hardware_type           ' Defines the hardware platform type (Hydra, Hydbrid)

    'sound toggles
    long    thrust

    byte    tile_map[24*32]

PRI UseSFX1
    sfx2.stop
    sfx_command       := sfx1#CMD__QUIET
    thrust_command    := sfx1#CMD__THRUST_OFF
    if not USE_KEYBOARD
        sfx1.start(@sfx_command)

PRI UseSFX2
    sfx1.stop
    sfx_command       := sfx1#CMD__QUIET
    thrust_command    := sfx1#CMD__THRUST_OFF
    if not USE_KEYBOARD
        sfx2.start(@sfx_command)

PRI UseNormalRenderer | i
    ClearPalette
    repeat i from 0 to constant(PLAYFIELD_RENDER_COGS-1)
        cogstop(8-PLAYFIELD_RENDER_COGS+i)
        rend_cog_number := i
        cog_numbers[i]:=p_rend.start(8-PLAYFIELD_RENDER_COGS+i,@rend_cog_number)
        'Wait to allow this cog to get the cog number param from the block before changing it.
        repeat 1000
    InitPalette

PRI UseTileRenderer | i
    ClearPalette
    repeat i from 0 to constant(PLAYFIELD_RENDER_COGS-1)
        cogstop(8-PLAYFIELD_RENDER_COGS+i)
        rend_cog_number := i
        cog_numbers[i]:=t_rend.start(8-PLAYFIELD_RENDER_COGS+i,@rend_cog_number)
        'Wait to allow this cog to get the cog number param from the block before changing it.
        repeat 1000
    InitPalette

PUB Main | i, time, game_counter, total_time, avg_time, t, temp



    'Mark top of stack to check later
    long[$7FFC]:=$DEAD_BEEF
    'Start renderers
    rend_sprite_def_ptr := gfx.sprite_adr
    rend_character_table_ptr := gfx.character_adr
    rend_laser_def_ptr := gfx.laser_adr
    rend_palette_ptr := 0
    rend_scanline_buffer_adr := @hub_scanline_buffer
    rend_scanline_req_adr := @scanline_req
    rend_playfield_cog_count := PLAYFIELD_RENDER_COGS
    rend_scanner_cog_count := SCANNER_RENDER_COGS
    rend_terrain_ptr := gfx.terrain_adr
    rend_tile_map_ptr := @tile_map

    rend_palette[0]:=$00000002 'black
    rend_palette[1]:=$0000000d 'laser/score/text color cycle
    rend_palette[2]:=$0000005c 'red
    rend_palette[3]:=$000000bc 'green
    rend_palette[4]:=$0000007e 'yellow
    rend_palette[5]:=$0000000e 'blue
    rend_palette[6]:=$00000005 'grey
    rend_palette[7]:=$0000006c 'brown 
    rend_palette[8]:=$0000002b 'pink
    rend_palette[9]:=$00000006  'white
    rend_palette[10]:=$000000cb 'color cycle (goes to white when 12 goes to black) pod on scanner
    rend_palette[11]:=$000000bd 'black - use for ship explosion white/yellow/orange/red/black
    rend_palette[12]:=$000000cd 'mutant/smartbomb color cycle
    rend_palette[13]:=$0000000e 'blue/yellow color cycle                                 \
    rend_palette[14]:=$0000000e 'blue/yellow color cycle (out of phase/time with 13)      | Humanoid capture bonus/Ship cockpit
    rend_palette[15]:=$0000005b 'red/yellow color cycle                                  /
    mutant_color := rend_palette[14]

    tv_scanline_request_adr := @scanline_req
    tv_scanline_buffer_adr := @hub_scanline_buffer
    tv_use_tv_on_pin24 := USE_TV_ON_PIN_24
    tv.start(@tv_scanline_request_adr)
    
    ClearScreen
    UseTileRenderer

    's_rend.start(@rend_cog_number)
    'Wait to allow this cog to get the cog number param from the block before changing it.
    'repeat 1000

    sfx_hardware_type:=HARDWARE
    sfx1.init
    sfx2.init
    if USE_KEYBOARD
        key.start(KEYSPIN)
    'uart.start(31, 30, 115200)

    dira[0]:=1

    'time:=CNT
    rnd:=$439845f0
    hi_score:=7650

    'Main Game Loop
    repeat
        'Check stack has not been overrun
        if long[$7FFC] <> $DEAD_BEEF
            DIRA[0]:=1
            OUTA[0]:=1
        'TV will let up know when there is a vsync
        tv_status := 0
        gp := NES_Read_Gamepad

        ' Clear sound API.  Start and stops happen on low to high transition.  So start low for eaxh frame.
        sfx_command := sfx1#CMD__IDLE

        if  gp & GP_SELECT
     '       Screen_Grab '' send screenshot over serial

        case game_state
            GAME_TITLE_INIT:
                s_rend.stop
                ClearScreen
                UseSFX2
                sfx_command := sfx1#CMD__LEVEL_DONE
                anim_count:=0
                game_state:=GAME_POST
            GAME_POST:
                case anim_count++
                    1:
                        Print(3,10,string("TESTS INDICATE:"))
                        Print(7,12,string("UNIT OK"))
                    300:
                        ClearScreen
                        sfx_command := sfx1#CMD__LEVEL_DONE
                        anim_count:=0
                        game_state:=GAME_TITLE                    
            GAME_TITLE:
                ColorCycle
                TitleAnimation
                if gp & GP_LEFT
                    game_two_players:=FALSE
                if gp & GP_RIGHT
                    game_two_players:=TRUE    
                if gp & GP_START or key.keystate(13)
                    game_state:=GAME_START
            GAME_START:
                game_player_up := -game_two_players ' This is zero based.  Pretend player 2 was up last tyo make player 1 up this time.  
                humanoids_alive := 10
                rend_bcd_score:=0   
                player_level[0]:=1
                game_state := GAME_LEVEL_INIT
            GAME_LEVEL_INIT:
                ClearScreen

                rend_sprite_locs[0]:= $20_00_10_00
                rend_sprite_tiles[0]:= 0
                rnd := 41925
                player_h_direction:=1
                player_v_direction:=0
                repeat i from 0 to constant(g#NUMBER_OF_LASER_SHOTS-1)
                    rend_lasers[i] := $ff
                UseSFX2
                s_rend.start(@rend_cog_number)
                UseNormalRenderer
                if humanoids_alive
                    rend_terrain_color:=TERRAIN_COLOR
                sfx_command := sfx2#CMD__START_GAME
                frame_count:=0
                game_state := GAME_LEVEL
            GAME_LEVEL:
                ColorCycle
                PlayerLogic
                LaserLogic
                AlienLogic
                PlanetLogic
                Bulletlogic
                if IsLevelEnd
                    game_state:=GAME_LEVEL_COMPLETED_INIT

            GAME_LEVEL_COMPLETED_INIT:
                frame_count:=0
                UseSFX2
                sfx_command := sfx2#CMD__LEVEL_DONE
                ClearScreen
                UseTileRenderer
                game_state:=GAME_LEVEL_COMPLETED

            GAME_LEVEL_COMPLETED:
                LevelCompleted
            GAME_OVER_INIT:
                game_state:=GAME_OVER
            GAME_OVER:
                if game_state_count++ == 192
                    game_state:=GAME_TITLE_INIT

        frame_count++
        if tv_status
            outa[0]:=1
        else
            outa[0]:=0            
        repeat until tv_status

PRI ClearScreen | i
    repeat i from 0 to constant(g#NUMBER_OF_SPRITES-1)
        rend_sprite_locs[i]:= $8000_0000
        rend_sprite_tiles[i]:= 0
        x_velocity[i]:=0
        y_velocity[i]:=0
        sprite_state[i]:=STATE_NOT_DEPLOYED
        target[i]:=-1
    repeat i from 0 to constant(g#NUMBER_OF_BULLETS-1)
        rend_bullets[i]:=INVISIBLE_LOCATION
    repeat i from 0 to constant(g#NUMBER_OF_LASER_SHOTS-1)
        rend_lasers[i]:=INVISIBLE_LOCATION
    repeat i from 0 to 24*32-1
        tile_map[i]:= 14

PRI PlayerLogic | i,advance,laser,player_base_position

    if (gp & GP_LEFT)
        player_h_direction := -1
        rend_sprite_tiles[0] := 1
    elseif (gp & GP_RIGHT)
        player_h_direction := 1
        rend_sprite_tiles[0] := 0

    if key.keystate($de)
        if reverse_button_up
            player_h_direction := -player_h_direction
            rend_sprite_tiles[0] ^= 1            
        reverse_button_up := FALSE
    else
        reverse_button_up := TRUE

    if gp & (GP_B | GP_LEFT | GP_RIGHT) or key.keystate($f1)
        player_x_velocity+=player_h_direction*c#CUST_PLAYER_THRUST_ACCEL
        if not thrust
            thrust_command := sfx1#CMD__THRUST_HIGH
            thrust:=TRUE
    else
        if thrust
            thrust_command := sfx1#CMD__THRUST_LOW
            thrust:=FALSE

    if player_x_velocity>0
        player_x_velocity-=c#CUST_PLAYER_DRAG
    elseif player_x_velocity<0
        player_x_velocity+=c#CUST_PLAYER_DRAG
 
    if gp & GP_UP or key.keystate($61)
        if player_v_direction<>-1
            player_v_direction:=-1
            player_y_velocity:=0
        player_y_velocity-=6
    elseif gp & GP_DOWN  or key.keystate($7a) 
        if player_v_direction<>1
            player_v_direction:=1
            player_y_velocity:=0
        player_y_velocity+=6
    else
        player_y_velocity:=0

    player_x_velocity <#= c#CUST_PLAYER_SPEED_LIMIT
    player_x_velocity #>= -c#CUST_PLAYER_SPEED_LIMIT
    player_y_velocity <#= c#CUST_PLAYER_CLIMB_LIMIT
    player_y_velocity #>= -c#CUST_PLAYER_CLIMB_LIMIT
                      
    rend_sprite_locs.word[SPRITE_XPOS]+=player_x_velocity
    rend_sprite_locs.word[SPRITE_YPOS]+=player_y_velocity
    rend_sprite_locs.word[SPRITE_YPOS]<#=constant(189<<6)
    rend_sprite_locs.word[SPRITE_YPOS]#>=constant(4<<6)
'    rend_sprite_locs.word[SPRITE_YPOS]:=WrapToY(rend_sprite_locs.word[SPRITE_YPOS])
    
    advance := ((player_x_velocity/6)-8)#>0
    'target_player_position
    player_base_position := 84-player_h_direction*48
    target_player_position := player_base_position+advance
    if player_position>target_player_position
        player_position-=1
    elseif player_position<target_player_position
        player_position+=1
    rend_side_scroll := ((rend_sprite_locs.word[SPRITE_XPOS]>>6)-player_position) & %1111111111

    if gp & GP_A or key.keystate($0d)
        if fire_button_up
            laser := ((rend_sprite_locs.word[SPRITE_YPOS]>>6)+1) ' y pos
            laser += (((||(player_position-player_base_position)))<#29) << 16 'tile
            if player_h_direction == 1
                laser|=$2800
            else
                laser|=$100_7f00
            rend_lasers[laser_state_count] :=laser
            laser_state_count++
            if laser_state_count==g#NUMBER_OF_LASER_SHOTS
                laser_state_count:=0
            sfx_command := sfx1#CMD__FIRE
        fire_button_up := FALSE
    else
        fire_button_up := TRUE

PRI AlienLogic | i,j, this_alien, this_humanoid, this_bonus, explode, h, x, y, terrain, distance, deltax, deltay, filter, new, alien_screen_x, xv, yv

    case frame_count
        c#CUST_HUMANOID_WAVE:
            repeat humanoids_alive
                i:=AllocSprite            
                rend_sprite_tiles[i]:= 4
                rend_sprite_locs[i]:= (180<<22) + (?rnd&$FFFF)
                sprite_state[i] := STATE_HUMANOID_MOVEMENT
                x_velocity[i] := (?rnd&%11)+1
                if ?rnd&1
                    x_velocity[i] := -x_velocity[i]    
                    rend_sprite_tiles[i]:= 3
        c#CUST_FIRST_WAVE:
            UseSFX1
            sfx_command := sfx1#CMD__WARP
            repeat j from 1 to g#LANDERS_PER_WAVE
                i:=AllocSprite
                rend_sprite_tiles[i]:= (45 << 16) + 2
                rend_sprite_locs[i]:= (19<<22) + (?rnd&$FFC0)
                sprite_state[i] := STATE_LANDER_APPEARING
                x_velocity[i] := (?rnd&$F)+16
                if ?rnd&1
                    x_velocity[i] := -x_velocity[i]
            repeat j from 1 to 5
                i:=AllocSprite            
                this_alien:= @rend_sprite_locs[i]
                rend_sprite_tiles[i]:= (45 << 16) + 6
                x_velocity[i] := 32
                y_velocity[i] := ?rnd&%11 +1 'multiplier for sin wave
                word[this_alien][SPRITE_XPOS]:=?rnd&$7FC0+(192<<6)
                word[this_alien][SPRITE_YPOS]:=WrapToY(  (Sin(word[this_alien][SPRITE_XPOS])<<(y_velocity[i])>>5)+(96<<6))
                sprite_state[i] := STATE_BOMBER_APPEARING
                if ?rnd&1
                    x_velocity[i] := -x_velocity[i]
            repeat j from 1 to 5
                i:=AllocSprite            
                this_alien:= @rend_sprite_locs[i]
                rend_sprite_tiles[i]:= (45 << 16) + 7
                word[this_alien][SPRITE_XPOS]:=?rnd&$3FC0+(192<<6)
                word[this_alien][SPRITE_YPOS]:=?rnd//(192<<6)
                sprite_state[i] := STATE_POD_APPEARING
                x_velocity[i] := ?rnd&%111
                y_velocity[i] := ?rnd&%111
                if ?rnd&1
                    x_velocity[i] := -x_velocity[i]
                if ?rnd&1
                    y_velocity[i] := -y_velocity[i]
        c#CUST_SECOND_WAVE:
            sfx_command := sfx1#CMD__WARP
            repeat j from 1 to g#LANDERS_PER_WAVE
                i:=AllocSprite            
                rend_sprite_tiles[i]:= (45 << 16) + 2
                rend_sprite_locs[i]:= (19<<22) + (?rnd&$FFC0)
                sprite_state[i] := STATE_LANDER_APPEARING
                x_velocity[i] := (?rnd&$F)+16
                if ?rnd&1
                    x_velocity[i] := -x_velocity[i]
        c#CUST_FIRST_BAITER, constant(c#CUST_FIRST_BAITER+c#CUST_SECOND_BAITER):
            sfx_command := sfx1#CMD__WARP
            i:=AllocSprite
            this_alien:= @rend_sprite_locs[i]
            rend_sprite_tiles[i]:= (45 << 16) + g#TILE_BAITER
            word[this_alien][SPRITE_XPOS]:=(rend_side_scroll + (?rnd&$FF))<<6
            word[this_alien][SPRITE_YPOS]:=19<<6
            sprite_state[i] := STATE_BAITER_APPEARING
            sprite_state_count[i]:=0

    if frame_count>constant(c#CUST_FIRST_BAITER+c#CUST_SECOND_BAITER) and not(frame_count&C#CUST_THEN_BAITER_EACH)
            sfx_command := sfx1#CMD__WARP
            i:=AllocSprite
            this_alien:= @rend_sprite_locs[i]
            rend_sprite_tiles[i]:= (45 << 16) + g#TILE_BAITER
            word[this_alien][SPRITE_XPOS]:=(rend_side_scroll + (?rnd&$FF))<<6
            word[this_alien][SPRITE_YPOS]:=19<<6
            sprite_state[i] := STATE_BAITER_APPEARING
            sprite_state_count[i]:=0

    repeat i from 1 to constant(g#NUMBER_OF_SPRITES-1)
        if sprite_state[i]>STATE_DEAD
            this_alien:= @rend_sprite_locs[i]

            'check if alien is onscreen
            alien_screen_x:=(word[this_alien][SPRITE_XPOS]>>6)-rend_side_scroll
            if alien_screen_x=>0 and alien_screen_x=<195
                sprite_onscreen[i]:=true
                'Check for player/alien collisions 
                case sprite_state[i]
                    STATE_LANDER_MOVEMENT..STATE_BAITER_MOVEMENT:
                       distance := rend_sprite_locs.word[SPRITE_XPOS]- word[this_alien][SPRITE_XPOS]
                       if ||distance < constant(6<<6)
                           distance := rend_sprite_locs.word[SPRITE_YPOS]- word[this_alien][SPRITE_YPOS]         
                           if ||distance < constant(6<<6)
                               sfx_command := sfx1#CMD__YOU_DIE
                               KillAlien(i)
            else
                sprite_onscreen[i]:=false

            case sprite_state[i]
                STATE_LANDER_APPEARING, STATE_BOMBER_APPEARING, STATE_POD_APPEARING, STATE_BAITER_APPEARING: 
                     if frame_count&1
                        explode := rend_sprite_tiles[i]>>16
                        if explode==0
                            if sprite_state[i] == STATE_LANDER_APPEARING
                                sprite_state[i] := STATE_LANDER_MOVEMENT
                            elseif sprite_state[i] == STATE_BOMBER_APPEARING
                                sprite_state[i] := STATE_BOMBER_MOVEMENT
                            elseif sprite_state[i] == STATE_POD_APPEARING
                                sprite_state[i] := STATE_POD_MOVEMENT
                            elseif sprite_state[i] == STATE_BAITER_APPEARING
                                sprite_state[i] := STATE_BAITER_MOVEMENT
                        else
                            explode--
                            rend_sprite_tiles[i] &= $FFFF
                            rend_sprite_tiles[i] |= (explode<<16)
             
                STATE_LANDER_MOVEMENT:
                    repeat h from 0 to constant(g#NUMBER_OF_SPRITES-1)
                        'Possibly the lander will target the humanoid
                        if sprite_state[h]==STATE_HUMANOID_MOVEMENT
                            this_humanoid := @rend_sprite_locs[h]
                            if word[this_humanoid][sprite_XPOS]&$FFC0 == word[this_alien][sprite_XPOS]&$FFC0
                                sprite_state[i] := STATE_LANDER_TARGETED
                                sprite_state[h] := STATE_HUMANOID_TARGETED
                                target[i] := h
                     
                    word[this_alien][SPRITE_XPOS]+=x_velocity[i]
                     
                    x := word[this_alien][SPRITE_XPOS]>>6
                    y := word[this_alien][SPRITE_YPOS]>>6
                    terrain := byte[rend_terrain_ptr][x]
                    if (terrain-y) > 40+i
                        ' head down
                        y_velocity[i]:=32
                    elseif (terrain-y) < 16+i
                        'head up
                        y_velocity[i]:=-16
                    else
                        y_velocity[i]:=0
                    word[this_alien][SPRITE_YPOS]+=y_velocity[i]
                    if not(?rnd&c#CUST_BULLET_RATE_MASK_LANDER)
                        'randomly fire a shot
                        if Shoot(i)                   
                            sfx_command := sfx1#CMD__LANDER_FIRE
             
                STATE_HUMANOID_MOVEMENT:
                    word[this_alien][SPRITE_XPOS]+=x_velocity[i]
                     
                    x := word[this_alien][SPRITE_XPOS]>>6
                    y := word[this_alien][SPRITE_YPOS]>>6
                    terrain := byte[rend_terrain_ptr][x]
                    if (y-terrain) <10
                        ' head down
                        y_velocity[i]:=32
                    elseif (y-terrain) > 12
                        'head up
                        y_velocity[i]:=-16
                    else
                        y_velocity[i]:=0
                    word[this_alien][SPRITE_YPOS]+=y_velocity[i]

                STATE_HUMANOID_FALLING:
                    word[this_alien][SPRITE_YPOS]+=y_velocity[i]
                    if frame_count&1
                        y_velocity[i]++

                    if word[this_alien][SPRITE_YPOS]>>6 > byte[rend_terrain_ptr][word[this_alien][SPRITE_XPOS]>>6]
                        'hit ground
                        if y_velocity[i]>50
                            sprite_state[i] := STATE_DYING
                            humanoids_alive--    
                            'sfx_stop_flags |= sfx1#SOUND__HUMAN_FALLING                              
                            sfx_command := sfx1#CMD__HUMAN_DIE
                        else
                            sprite_state[i] := STATE_HUMANOID_MOVEMENT
                            new:=AllocSprite
                            this_bonus:= @rend_sprite_locs[new]
                            rend_sprite_tiles[new]:=g#TILE_BONUS_2
                            word[this_bonus][SPRITE_XPOS]:=word[this_alien][SPRITE_XPOS]
                            word[this_bonus][SPRITE_YPOS]:=word[this_alien][SPRITE_YPOS]-constant(16<<6)
                            sprite_state[new] := STATE_BONUS
                            x_velocity[new] := player_x_velocity>>1
                            y_velocity[new]:=128 'use y_velocity for time to live
                            new:=AllocSprite
                            this_bonus:= @rend_sprite_locs[new]
                            rend_sprite_tiles[new]:=g#TILE_BONUS_50
                            word[this_bonus][SPRITE_XPOS]:=word[this_alien][SPRITE_XPOS]+constant(8<<6)
                            word[this_bonus][SPRITE_YPOS]:=word[this_alien][SPRITE_YPOS]-constant(16<<6)
                            sprite_state[new] := STATE_BONUS
                            x_velocity[new] := player_x_velocity>>1
                            y_velocity[new]:=128 'use y_velocity for time to live
                            AddScore(250)
                            sfx_command := sfx1#CMD__HUMAN_RETURNED                            
                    else
                        'still falling
                        distance := word[this_alien][SPRITE_XPOS]-rend_sprite_locs.word[SPRITE_XPOS]
                        if distance<constant(5<<6) and distance>constant(-5<<6)
                            distance := word[this_alien][SPRITE_YPOS]-rend_sprite_locs.word[SPRITE_YPOS]
                            if distance<constant(8<<6) and distance>constant(-8<<6)
                                sprite_state[i]:=STATE_HUMANOID_HANGING
                                new:=AllocSprite
                                this_bonus:= @rend_sprite_locs[new]
                                rend_sprite_tiles[new]:=g#TILE_BONUS_5
                                word[this_bonus][SPRITE_XPOS]:=word[this_alien][SPRITE_XPOS]
                                word[this_bonus][SPRITE_YPOS]:=word[this_alien][SPRITE_YPOS]-constant(16<<6)
                                sprite_state[new] := STATE_BONUS
                                x_velocity[new] := player_x_velocity>>1
                                y_velocity[new]:=128 'use y_velocity for time to live
                                new:=AllocSprite
                                this_bonus:= @rend_sprite_locs[new]
                                rend_sprite_tiles[new]:=g#TILE_BONUS_00
                                word[this_bonus][SPRITE_XPOS]:=word[this_alien][SPRITE_XPOS]+constant(8<<6)
                                word[this_bonus][SPRITE_YPOS]:=word[this_alien][SPRITE_YPOS]-constant(16<<6)
                                sprite_state[new] := STATE_BONUS
                                x_velocity[new] := player_x_velocity>>1
                                y_velocity[new]:=128 'use y_velocity for time to live
                                AddScore(500)
                                'sfx_stop_flags |= sfx1#SOUND__HUMAN_FALLING
                                sfx_command := sfx1#CMD__HUMAN_CAUGHT
                                 
                STATE_HUMANOID_HANGING:
                    word[this_alien][SPRITE_XPOS]:=rend_sprite_locs.word[SPRITE_XPOS]
                    word[this_alien][SPRITE_YPOS]:=rend_sprite_locs.word[SPRITE_YPOS]+constant(10<<6)
                    if word[this_alien][SPRITE_YPOS]>>6 > byte[rend_terrain_ptr][word[this_alien][SPRITE_XPOS]>>6]
                        sprite_state[i] := STATE_HUMANOID_MOVEMENT
                        new:=AllocSprite
                        this_bonus:= @rend_sprite_locs[new]
                        rend_sprite_tiles[new]:=g#TILE_BONUS_5
                        word[this_bonus][SPRITE_XPOS]:=word[this_alien][SPRITE_XPOS]
                        word[this_bonus][SPRITE_YPOS]:=word[this_alien][SPRITE_YPOS]-constant(16<<6)
                        sprite_state[new] := STATE_BONUS
                        x_velocity[new] := player_x_velocity>>1
                        y_velocity[new]:=128 'use y_velocity for time to live
                        new:=AllocSprite
                        this_bonus:= @rend_sprite_locs[new]
                        rend_sprite_tiles[new]:=g#TILE_BONUS_00
                        word[this_bonus][SPRITE_XPOS]:=word[this_alien][SPRITE_XPOS]+constant(8<<6)
                        word[this_bonus][SPRITE_YPOS]:=word[this_alien][SPRITE_YPOS]-constant(16<<6)
                        sprite_state[new] := STATE_BONUS
                        x_velocity[new] := player_x_velocity>>1
                        y_velocity[new]:=128 'use y_velocity for time to live
                        AddScore(500)
                        sfx_command := sfx1#CMD__HUMAN_RETURNED
                         
                STATE_BONUS:
                    if not frame_count&%11
                        word[this_alien][SPRITE_XPOS]+=x_velocity[i]++
                    if not y_velocity[i]--
                        sprite_state[i] := STATE_NOT_DEPLOYED
                        rend_sprite_locs[i]:=INVISIBLE_LOCATION
             
                STATE_BOMBER_MOVEMENT:
                    word[this_alien][SPRITE_XPOS]+=x_velocity[i]
                    word[this_alien][SPRITE_YPOS]:=WrapToY(  (Sin(word[this_alien][SPRITE_XPOS])<<(y_velocity[i])>>5)+(96<<6))
                    if not frame_count&c#CUST_MINE_RATE_MASK_BOMBER
                        'Lay a mine regularly after every so many frames, provided ammunition available.
                        Mine(i)                   
                        
                STATE_POD_MOVEMENT:
                    word[this_alien][SPRITE_XPOS]+=x_velocity[i]
                    word[this_alien][SPRITE_YPOS]:=WrapToY(word[this_alien][SPRITE_YPOS]+y_velocity[i])
             
                STATE_SWARMER_MOVEMENT:
                    if not (frame_count&%111111)
                        if x_velocity[i]>0
                            distance := word[this_alien][SPRITE_XPOS]-rend_sprite_locs.word[SPRITE_XPOS]
                            if (distance>constant(128<<6)) or (sprite_state_count-- == 0)
                                x_velocity[i]:= -c#CUST_SWARMER_HORIZONTAL_SPEED
                        else
                            distance := rend_sprite_locs.word[SPRITE_XPOS]-word[this_alien][SPRITE_XPOS]
                            if (distance>constant(128<<6)) or (sprite_state_count-- == 0)
                                x_velocity[i]:= c#CUST_SWARMER_HORIZONTAL_SPEED
                    word[this_alien][SPRITE_XPOS]+=x_velocity[i]
                    word[this_alien][SPRITE_YPOS]+=y_velocity[i]
                    if word[this_alien][SPRITE_YPOS]>constant(192<<6)
                        y_velocity[i] := -y_velocity[i]    
                    if not(?rnd&c#CUST_BULLET_RATE_MASK_SWARMER)
                        'randomly fire a shot
                        if SwarmerShoot(i)                   
                            sfx_command := sfx1#CMD__SWARMER

                STATE_LANDER_TARGETED:
                    if sprite_state[target[i]]<>STATE_HUMANOID_TARGETED
                        sprite_state[i]:=STATE_LANDER_MOVEMENT    
                    this_humanoid := @rend_sprite_locs[target[i]]
                    distance := (word[this_humanoid][SPRITE_YPOS]>>6)-(word[this_alien][SPRITE_YPOS]>>6)
                    if distance<13
                        sprite_state[i] := STATE_LANDER_ASCENDING
                        sprite_state[target[i]] := STATE_HUMANOID_ASCENDING
                        sfx_command := sfx1#CMD__HUMAN_ABDUCTED  
                    else
                        word[this_alien][SPRITE_YPOS]+=16
                        if not(?rnd&c#CUST_BULLET_RATE_MASK_LAND_TAR)
                            'randomly fire a shot
                            if Shoot(i)                   
                                sfx_command := sfx1#CMD__LANDER_FIRE
                     
                STATE_LANDER_ASCENDING:
                    this_humanoid := @rend_sprite_locs[target[i]]
                    if word[this_alien][SPRITE_YPOS] > constant(8<<6)
                        word[this_alien][SPRITE_YPOS]-=32
                    word[this_humanoid][SPRITE_YPOS]-=32
                    if word[this_humanoid][SPRITE_YPOS] < constant(8<<6)
                        sprite_state[target[i]]:=STATE_DYING
                        target[i]:=-1
                        'long[this_humanoid]:=-1
                        sprite_state[i]:=STATE_MUTANT_MOVEMENT
                        rend_sprite_tiles[i]:= 5
                        humanoids_alive--
                        sfx_command := sfx1#CMD__HUMAN_DIE
                    else
                        if not(?rnd&c#CUST_BULLET_RATE_MASK_LAND_ASC)
                            'randomly fire a shot
                            if Shoot(i)                   
                                sfx_command := sfx1#CMD__LANDER_FIRE
             
                STATE_MUTANT_MOVEMENT:
                    ' delta x is shifted left to wrap around at 1024 pixel landsacape width.  i.e. -512 to +511
                    deltax := (word[this_alien][SPRITE_XPOS]-rend_sprite_locs.word[SPRITE_XPOS])
                    deltay := (word[this_alien][SPRITE_YPOS]-rend_sprite_locs.word[SPRITE_YPOS])
                    if deltax > 80
                        x_velocity[i] := -48
                        CalcDistantMutantY(i,deltay)    
                    elseif deltax < -80
                        x_velocity[i] := 48
                        CalcDistantMutantY(i,deltay)    
                    else
                        CalcCloseMutantY(i,deltay)
                    word[this_alien][SPRITE_XPOS]+=x_velocity[i]
                    word[this_alien][SPRITE_YPOS]:=WrapToY(word[this_alien][SPRITE_YPOS]+y_velocity[i])
                    if not(?rnd&c#CUST_BULLET_RATE_MASK_MUTANT)
                        'randomly fire a shot
                        if Shoot(i)               
                            sfx_command := sfx1#CMD__MUTANT

                STATE_BAITER_MOVEMENT:
                    if not sprite_state_count[i]--
                        xv:=(rend_sprite_locs.word[SPRITE_XPOS]-word[this_alien][SPRITE_XPOS])<<16
                        xv~>=constant(16+c#CUST_BAITER_SPEED_SHIFT)
                        xv~>=c#CUST_BAITER_INACCURACY_SHIFT
                        xv<<=c#CUST_BAITER_INACCURACY_SHIFT
                        yv:=(rend_sprite_locs.word[SPRITE_YPOS]-word[this_alien][SPRITE_YPOS])
                        yv~>=c#CUST_BAITER_SPEED_SHIFT
                        yv~>=c#CUST_BAITER_INACCURACY_SHIFT
                        yv<<=c#CUST_BAITER_INACCURACY_SHIFT
                        y_velocity[i]:=yv+?rnd&$f-?rnd&$f
                        y_velocity[i]<#=128
                        y_velocity[i]#>=-128
                        x_velocity[i]:=xv+player_x_velocity+?rnd&$f-rnd&$f
                        x_velocity[i]<#=128
                        x_velocity[i]#>=-128
                        sprite_state_count[i]:=?rnd&$7f+20
                    word[this_alien][SPRITE_XPOS]+=x_velocity[i]
                    word[this_alien][SPRITE_YPOS]+=y_velocity[i]
             
                STATE_DYING:
                    if frame_count&1
                        explode := rend_sprite_tiles[i]>>16
                        if explode==45
                            sprite_state[i] := STATE_DEAD
                            rend_sprite_locs[i]:=INVISIBLE_LOCATION
                        else
                            explode++
                            rend_sprite_tiles[i] &= $FFFF
                            rend_sprite_tiles[i] |= (explode<<16)
            
PRI CalcDistantMutantY(i,deltay)
    if deltay<(8<<6) and deltay>(-8<<6)
        CalcCloseMutantY(i,deltay)
        y_velocity[i]:= -y_velocity[i]
    else
        if frame_count&3
            y_velocity[i]:=0
        elseif ?rnd&1
            y_velocity[i]:=64
        else
            y_velocity[i]:=-64
      
PRI CalcCloseMutantY(i,deltay) | r
    r := ?rnd&$F
    if r=<0
        y_velocity[i]:=-64
    elseif r=<7
        y_velocity[i]:=0
    elseif r=<13
        y_velocity[i]:=64
    else
        y_velocity[i]:=128
    if deltay>0
        y_velocity[i]:= -y_velocity[i]

PRI WrapToY(y)
    y:=~~y
    repeat while y<6
        y+=constant(192<<6)
    repeat while y>constant(192<<6)
        y-=constant(192<<6)
    return y

PRI Sin(angle) : y
''Get sine of angle (0-$1FFF)
    angle>>=3
    y := angle << 1 & $FFE
    if angle & $800
       y := word[$F000 - y]
    else
       y := word[$E000 + y]
    if angle & $1000
       -y

    y<<=15
    y~>=17

           
PRI LaserLogic | i,e,this_laser, this_enemy,tile, ly, ex,ey, reverse, current_ex, current_dead_alien, ex_extended, laser_left, laser_right, bottom,top
    repeat i from 0 to constant(g#NUMBER_OF_LASER_SHOTS-1)
        this_laser:=@rend_lasers[i]                                                                    
        ly := byte[this_laser][0]
        tile := byte[this_laser][2]
        reverse := byte[this_laser][3]
        if tile==g#NUMBER_OF_LASER_FRAMES
            byte[this_laser][0] := $FF
        if byte[this_laser][0] <> $FF
            byte[this_laser][2] := ++tile
            if not reverse
                laser_right:=(constant($28+8) +tile<<2 +rend_side_scroll)
                laser_left:=($28 + tile + rend_side_scroll)
                current_ex := g#TERRAIN_WIDTH
            else
                laser_left:=(constant($7f-8) -tile<<2 +rend_side_scroll)
                laser_right:=($7f - tile + rend_side_scroll)
                current_ex := 0            
            current_dead_alien := -1
            repeat e from 1 to g#NUMBER_OF_SPRITES
                if sprite_state[e]>STATE_LIVE_STATES
                    if sprite_onscreen[e]
                        this_enemy:=@rend_sprite_locs[e]
                        ey := word[this_enemy][SPRITE_YPOS]>>6
                        case sprite_state[e]
                            STATE_SWARMER_MOVEMENT,STATE_BAITER_MOVEMENT:
                                top:= ey-2
                                bottom:=ey+1
                            STATE_POD_MOVEMENT:
                                top:= ey-3
                                bottom:=ey+2
                            OTHER:
                                top:= ey-4
                                bottom:=ey+3
                        if (ly =< bottom) and (ly=>top)
                            ex := word[this_enemy][SPRITE_XPOS]>>6
                            if not reverse
                                ex_extended := ex+g#TERRAIN_WIDTH
                                if  (ex<current_ex) and (((ex>laser_left) and (ex<laser_right)) or ((ex_extended>laser_left) and (ex_extended<laser_right)))
                                        current_ex:=ex
                                        current_dead_alien:=e
                            else
                                ex_extended := ex+g#TERRAIN_WIDTH
                                if  (ex>current_ex) and (((ex>laser_left) and (ex<laser_right)) or ((ex_extended>laser_left) and (ex_extended<laser_right)))
                                        current_ex:=ex
                                        current_dead_alien:=e
             
            if current_dead_alien>0
                KillAlien(current_dead_alien)
                byte[this_laser][0] := $FF
        this_laser += 4

PRI KillAlien(i) | new
    CASE sprite_state[i]
        STATE_HUMANOID_MOVEMENT..STATE_HUMANOID_FALLING:
            humanoids_alive--
            'sfx_stop_flags |= sfx1#SOUND__HUMAN_FALLING
            sfx_command := sfx1#CMD__HUMAN_DIE
        STATE_LANDER_MOVEMENT..STATE_MUTANT_MOVEMENT:
            sfx_command := sfx1#CMD__LANDER_DIE
            AddScore(150)
        STATE_BOMBER_MOVEMENT:
            AddScore(250)
        STATE_POD_MOVEMENT:
            sfx_command := sfx1#CMD__POD
            AddScore(1000)
            repeat 4
                new:=AllocSprite
                rend_sprite_tiles[new]:=g#TILE_SWARMER
                rend_sprite_locs[new]:=rend_sprite_locs[i]
                sprite_state[new] := STATE_SWARMER_MOVEMENT
                x_velocity[new] := ?rnd&%11111+16
                if ?rnd&1
                    x_velocity[new] := -x_velocity[new]   
                y_velocity[new] := ?rnd&%1111+16
                if ?rnd&1
                    y_velocity[new] := -y_velocity[new]
                sprite_state_count:=c#CUST_SWARMER_HATCH_FRAMES
        STATE_BAITER_MOVEMENT:
            AddScore(200)

    sprite_state[i]:=STATE_DYING
    if target[i]>-1
        case sprite_state[target[i]]
            STATE_HUMANOID_ASCENDING:
                sprite_state[target[i]]:=STATE_HUMANOID_FALLING
                sfx_command := sfx1#CMD__HUMAN_FALLING   
            STATE_HUMANOID_TARGETED:
                sprite_state[target[i]]:=STATE_HUMANOID_MOVEMENT
        y_velocity[target[i]]:=0
        target[i]:=-1
     
PRI PlanetLogic | i
    if humanoids_alive==0 and rend_terrain_color==TERRAIN_COLOR
        rend_terrain_color:=$02
        sfx_command := sfx1#CMD__PLANET_EXPLODE
        repeat i from 0 to constant(g#NUMBER_OF_SPRITES-1)
            if sprite_state[i]=>STATE_LANDER_MOVEMENT and sprite_state[i]=<STATE_LANDER_ASCENDING
                sprite_state[i]:=STATE_MUTANT_MOVEMENT
                rend_sprite_tiles[i]:= 5

PRI BulletLogic | i, this_bullet, distance
    repeat i from 0 to constant(g#NUMBER_OF_BULLETS-1)
        this_bullet:=@rend_bullets[i]
        distance := rend_sprite_locs.word[SPRITE_XPOS]-word[this_bullet][SPRITE_XPOS]
        if ||distance < constant(4<<6)
            distance := rend_sprite_locs.word[SPRITE_YPOS]-word[this_bullet][SPRITE_YPOS]         
            if ||distance < constant(3<<6)
                sfx_command := sfx1#CMD__YOU_DIE
                rend_bullets[i]:=INVISIBLE_LOCATION
        if rend_bullets[i]=>0
            if --bullet_time_to_live[i]
                this_bullet:=@rend_bullets[i]
                word[this_bullet][SPRITE_XPOS]+=bullet_velocity_x[i]
                word[this_bullet][SPRITE_YPOS]+=bullet_velocity_y[i]
            else
                rend_bullets[i]:=INVISIBLE_LOCATION

{PRI CollisionLogic | i, this_alien, distance
    repeat i from 1 to constant(g#NUMBER_OF_SPRITES-1)
        this_alien:=@rend_sprite_locs[i]
        if sprite_state > STATE_LIVE_STATES
            distance := rend_sprite_locs.word[SPRITE_XPOS]-word[this_alien][SPRITE_XPOS]
            if ||distance < constant(6<<6)
                distance := rend_sprite_locs.word[SPRITE_YPOS]-word[this_alien][SPRITE_YPOS]         
                if ||distance < constant(5<<6)
                    sfx_command := sfx1#CMD__YOU_DIE
                    KillAlien(i)
}
PRI Shoot(alien) | i, this_bullet, this_alien, xv,yv
    this_alien:=@rend_sprite_locs[alien]
    if sprite_onscreen[alien]
        repeat i from 0 to constant(g#NUMBER_OF_BULLETS-1)
            if rend_bullets[i]<0
                xv:=(rend_sprite_locs.word[SPRITE_XPOS]-word[this_alien][SPRITE_XPOS])<<16~>constant(16+c#CUST_BULLET_SPEED_SHIFT)
                yv:=(rend_sprite_locs.word[SPRITE_YPOS]-word[this_alien][SPRITE_YPOS])~>c#CUST_BULLET_SPEED_SHIFT
                if ||xv+||yv >c#CUST_POINT_BLANK_RANGE
                    bullet_velocity_y[i]:=yv
                    bullet_velocity_x[i]:=xv+player_x_velocity
                    bullet_time_to_live[i]:=c#CUST_BULLET_TIME_TO_LIVE
                    this_bullet:=@rend_bullets[i]
                    word[this_bullet][SPRITE_XPOS]:=word[this_alien][SPRITE_XPOS]
                    word[this_bullet][SPRITE_YPOS]:=word[this_alien][SPRITE_YPOS]
                    return true
    return false

PRI SwarmerShoot(alien) | i, this_bullet, this_alien, xv,yv
    'Swarmer bullets are faster, but less accurate.
    this_alien:=@rend_sprite_locs[alien]
    if sprite_onscreen[alien]
        repeat i from 0 to constant(g#NUMBER_OF_BULLETS-1)
            if rend_bullets[i]<0
                xv:=(rend_sprite_locs.word[SPRITE_XPOS]-word[this_alien][SPRITE_XPOS])<<16
                xv~>=constant(16+c#CUST_BULLET_SPEED_SHIFT_SWARM)
                xv~>=c#CUST_SWARMER_INACCURACY_SHIFT
                xv<<=c#CUST_SWARMER_INACCURACY_SHIFT
                yv:=(rend_sprite_locs.word[SPRITE_YPOS]-word[this_alien][SPRITE_YPOS])
                yv~>=c#CUST_BULLET_SPEED_SHIFT_SWARM
                yv~>=c#CUST_SWARMER_INACCURACY_SHIFT
                yv<<=c#CUST_SWARMER_INACCURACY_SHIFT
                if ||xv+||yv >c#CUST_POINT_BLANK_RANGE
                    bullet_velocity_y[i]:=yv
                    bullet_velocity_x[i]:=xv+player_x_velocity
                    bullet_time_to_live[i]:=c#CUST_BULLET_TIME_TO_LIVE
                    this_bullet:=@rend_bullets[i]
                    word[this_bullet][SPRITE_XPOS]:=word[this_alien][SPRITE_XPOS]
                    word[this_bullet][SPRITE_YPOS]:=word[this_alien][SPRITE_YPOS]
                    return true
    return false

PRI Mine(alien) | i, this_bullet, this_alien, xv,yv
    this_alien:=@rend_sprite_locs[alien]
    if sprite_onscreen[alien]
        repeat i from 0 to constant(g#NUMBER_OF_BULLETS-1)
            if rend_bullets[i]<0
                bullet_velocity_y[i]:=0
                bullet_velocity_x[i]:=0
                bullet_time_to_live[i]:=c#CUST_MINE_TIME_TO_LIVE
                this_bullet:=@rend_bullets[i]
                word[this_bullet][SPRITE_XPOS]:=word[this_alien][SPRITE_XPOS]
                word[this_bullet][SPRITE_YPOS]:=word[this_alien][SPRITE_YPOS]
                return true
    return false

PRI IsLevelEnd | i
    if frame_count=<c#CUST_SECOND_WAVE
        return false
    repeat i from 0 to constant(g#NUMBER_OF_SPRITES-1)
        case sprite_state[i]
            STATE_LANDER_APPEARING,STATE_BOMBER_APPEARING,STATE_POD_APPEARING,STATE_LANDER_MOVEMENT,STATE_LANDER_TARGETED,STATE_LANDER_ASCENDING,STATE_MUTANT_MOVEMENT,STATE_BOMBER_MOVEMENT,STATE_POD_MOVEMENT,STATE_SWARMER_MOVEMENT:
                return false
    return true
    
PRI LevelCompleted | i, j, this, p, x, humanoids
    case frame_count
        1:
            humanoids:=10
            repeat i from 0 to constant(g#NUMBER_OF_SPRITES-1)
                case sprite_state[i]
                    STATE_HUMANOID_MOVEMENT..STATE_HUMANOID_HANGING:
                        humanoids++
            ClearScreen
            rend_side_scroll:=0
            Print(4,5,string("ATTACK WAVE 1"))
            Print(6,7,string("COMPLETED"))
            Print(5,12,string("BONUS X 100"))

        c#CUST_LEVEL_COMPLETED_FRAMES:
            player_level[0]++
            game_state:=GAME_LEVEL_INIT

    if humanoids
        repeat i from 0 to humanoids-1
            if frame_count==4+i*6
                j:=AllocSprite
                rend_sprite_tiles[j]:=3
                this:= @rend_sprite_locs[j]
                word[this][SPRITE_YPOS]:=120<<6
                word[this][SPRITE_XPOS]:=(48<<6)+(i<<9)
                AddScore((player_level[0]//10)*100)

PRI TitleAnimation | x,y,wait

    case anim_count++
        0:
            waddicors_tile_num:=53
            waddicors_draw_list:=@waddicors_draw_list_def
            waddicors_next_frame:=1

        215:
            Print(6,6,string("GAMES INC"))
        550:
            Print(1,19,string("GAME:STEVE WADDICOR"))
        600:
            Print(1,22,string("SOUND FX:ERIC MOYER"))
        700:
            Print(5,15,string("PRESS START"))        
        2000:
            ClearScreen
            anim_count:=-1
            
    if anim_count==waddicors_next_frame
        x:=byte[waddicors_draw_list]
        if x
            waddicors_draw_list++
            y:=byte[waddicors_draw_list++]
            wait:=byte[waddicors_draw_list++]
            byte[@tile_map+y*32+x]:=waddicors_tile_num++
            waddicors_next_frame+=wait


DAT
waddicors_draw_list_def
            byte        7,3,3
            byte        7,2,3
            byte        7,3,3
            byte        7,4,3
            byte        7,3,3
            byte        8,3,3
            byte        8,2,3
            byte        7,3,3            
            byte        7,4,3
            byte        8,4,3
            byte        8,3,3
            byte        8,2,3
            byte        8,3,3
            byte        8,4,3
            byte        9,4,3
            byte        9,3,3
            byte        8,4,3
            byte        9,4,3
            byte        9,3,3
            byte        9,4,3
            byte        9,3,3
            byte        10,3,3
            byte        10,2,3
            byte        9,4,3
            byte        10,4,3
            byte        10,3,3
            byte        10,2,3
            byte        10,4,3
            byte        10,3,3
            byte        10,4,3
            byte        11,4,3
            byte        11,3,3
            byte        11,4,3
            byte        11,3,3
            byte        11,4,3
            byte        12,4,3
            byte        12,3,3
            byte        12,4,3
            byte        12,3,3
            byte        12,4,3
            byte        12,3,3
            byte        13,3,3
            byte        12,3,3
            byte        12,4,3
            byte        13,4,3
            byte        13,3,3
            byte        13,4,30
            byte        11,3,1
            byte        11,2,3
            byte        13,3,60
            byte        13,2,3
            byte        13,3,3            
            byte        13,2,3            
            byte        12,2,3
            byte        12,3,60

            'Defender

            byte        4,10,2
            byte        5,10,2
            byte        6,10,2
            byte        7,10,2
            byte        8,10,2
            byte        9,10,2
            byte        10,10,2
            byte        11,10,2
            byte        12,10,2
            byte        13,10,2
            byte        14,10,2
            byte        15,10,2
            byte        16,10,2

            byte        3,11,2
            byte        4,11,2
            byte        5,11,2
            byte        6,11,2
            byte        7,11,2
            byte        8,11,2
            byte        9,11,2
            byte        10,11,2
            byte        11,11,2
            byte        12,11,2
            byte        13,11,2
            byte        14,11,2
            byte        15,11,2
            byte        16,11,2
            byte        17,11,2

            byte        3,12,2
            byte        4,12,2
            byte        5,12,2
            byte        6,12,2
            byte        7,12,2
            byte        8,12,2
            byte        9,12,2
            byte        10,12,2
            byte        11,12,2
            byte        12,12,2
            byte        13,12,2
            byte        14,12,2
            byte        15,12,2
            byte        16,12,2
            byte        17,12,2
            
            byte        0

PRI Print(x,y,str) | map,char
    map:=@tile_map+y*32+x
    repeat while byte[str]
        case byte[str]
            32:
                char:=14
            48..58:
                char:=byte[str]-48+15
            65..90:
                char:=byte[str]-65+26
            91..255:
                char:=byte[str]-91+53    
        byte[map++]:=char
        str++
                 
PRI AllocSprite | i
    repeat i from 0 to constant(g#NUMBER_OF_SPRITES-1)
        if rend_sprite_locs[i]<0
            return i
    repeat i from 0 to constant(g#NUMBER_OF_SPRITES-1)
        if sprite_state[i]==STATE_MUTANT_MOVEMENT
            return i
    repeat i from 0 to constant(g#NUMBER_OF_SPRITES-1)
        if sprite_state[i]==STATE_LANDER_MOVEMENT
            return i
    return 3

PRI Rotate(item_ptr,increment,lower,upper)
    ' Rotate a byte value through a range of values.  Useful for sprite animation.
    ' byte_item = pointer to a variable to ,reset,lower,upper)
    ' increment = value to add or subtract
    ' lower     = lower bound
    ' upper     = upper bound
    long[item_ptr]+=increment
    if long[item_ptr]>upper
        long[item_ptr] := lower
    if long[item_ptr]<lower
        long[item_ptr] := upper

Pri SetScore(n) | temp, i
    score:=n
    temp:=score
    rend_bcd_score:=0
    repeat i from 0 to 7
        rend_bcd_score|=temp//10
        rend_bcd_score->=4
        temp/=10

Pri AddScore(n) | temp, i
    score+=n
    temp:=score
    rend_bcd_score:=0
    repeat i from 0 to 7
        rend_bcd_score|=temp//10
        rend_bcd_score->=4
        temp/=10

PRI InitPalette
    rend_palette[0]:=$00000002 'black
    rend_palette[1]:=$000000bd 'laser/score/text color cycle
    rend_palette[2]:=$0000005c 'red
    rend_palette[3]:=$000000bc 'green
    rend_palette[4]:=$0000006e 'yellow
    rend_palette[5]:=$0000000e 'blue
    rend_palette[6]:=$00000005 'grey
    rend_palette[7]:=$0000006c 'brown 
    rend_palette[8]:=$0000002b 'pink
    rend_palette[9]:=$00000006  'white
    rend_palette[10]:=$000000cb 'color cycle (goes to white when 12 goes to black) pod on scanner
    rend_palette[11]:=$000000bd 'black - use for ship explosion white/yellow/orange/red/black
    rend_palette[12]:=$000000cd 'mutant/smartbomb color cycle
    rend_palette[13]:=$0000000e 'blue/yellow color cycle                                 \
    rend_palette[14]:=$0000000e 'blue/yellow color cycle (out of phase/time with 13)      | Humanoid capture bonus/Ship cockpit
    rend_palette[15]:=$0000005b 'red/yellow color cycle                                  /
    mutant_color := rend_palette[14]

PRI ClearPalette | i
    repeat i from 0 to 15
        rend_palette[i]:=$02
    mutant_color := rend_palette[14]
    rend_terrain_color := $02
    
PRI ColorCycle
    case frame_count& $F
            0:
                'laser
                rend_palette[1]+=$10
                'mutant
                rend_palette[10]:=$06
                rend_palette[12]:=$02
                'bonus
                rend_palette[13]:=$0b
                rend_palette[15]:=$7d
            3:
                'laser
                rend_palette[1]+=$10
                'mutant
                mutant_color+=$40
                mutant_color&=$FF
                rend_palette[10]:=mutant_color
                rend_palette[12]:=mutant_color
            5:
                'bonus
                rend_palette[14]:=$7d
                rend_palette[15]:=$5c
            6:
                'laser
                rend_palette[1]+=$10
            8:
                'mutant
                rend_palette[10]:=$06
                rend_palette[12]:=$02
            9:
                'laser
                rend_palette[1]+=$10
            10:
                'bonus
                rend_palette[13]:=$7d
                rend_palette[14]:=$0b
            11:
                'mutant
                mutant_color+=$40
                mutant_color&=$FF
                rend_palette[10]:=mutant_color
                rend_palette[12]:=mutant_color
            12:
                'laser
                rend_palette[1]+=$10
    rend_palette[1]&=$FF
     
PUB Screen_Grab | x, y, i
    '' Stop the TV driver, send 16 bits of X pixel width, send 16 bits of Y pixel
    ''    height, send the screen data, then when all is finished send $FF to tell
    ''    client no more pixel data is coming. After that is done start up the TV
    ''    driver.

    x := 320 
    y := 222
     
    tv.stop
    ''send X screen width - 16 bits big endian
    uart.tx(x>>8)
    uart.tx(x&$FF)
    ''send Y screen length - 16 bits big endian
    uart.tx(y>>8)
    uart.tx(y&$FF)

    'Trick renderer into generating first line by doing a dummy run.
    repeat i from 0 to y-1
        long[rend_scanline_req_adr]:=i
        waitcnt(10000+cnt)
        
    repeat i from 0 to 29
        Screen_Grab_Line_Scanner(i)
    repeat i from 30 to y-1
        Screen_Grab_Line_Playfield(i)

    uart.tx($FF) ' - all done
    long[rend_scanline_req_adr]:= 0
    ''start tv driver up again
    tv.start(@tv_scanline_request_adr)

PRI Screen_Grab_Line_Scanner(line) | pixel_adr, cur_pixel, temp_color 
    long[rend_scanline_req_adr]:= line
    pixel_adr:=rend_scanline_buffer_adr+4
    ''read scanline and send scanline
    repeat 80
        cur_pixel:=byte[pixel_adr]
        ''fix for reversed palette
        ''cur_pixel-=1 ''adjust color
        temp_color:=(($F-(cur_pixel>>4))+1)&$F
        cur_pixel&=$F
        cur_pixel|=temp_color<<4
        pixel_adr+=1 ''move to next pixel
        repeat 4
            uart.tx(cur_pixel) ' - send byte twice (for fat pixels)
     
PRI Screen_Grab_Line_Playfield(line) | pixel_adr, cur_pixel, temp_color
    long[rend_scanline_req_adr]:= line
    pixel_adr:=rend_scanline_buffer_adr+8
    ''read scanline and send scanline
    repeat 160
        cur_pixel:=byte[pixel_adr]
        ''fix for reversed palette
        ''cur_pixel-=1 ''adjust color
        temp_color:=(($F-(cur_pixel>>4))+1)&$F
        cur_pixel&=$F
        cur_pixel|=temp_color<<4
        pixel_adr+=1 ''move to next pixel
        repeat 2
            uart.tx(cur_pixel) ' - send byte 4 times (for scanner pixels)
     
PUB NES_Read_Gamepad : nes_bits        |  i
    ' set I/O ports to proper direction
    ' P3 = JOY_CLK      (4)
    ' P4 = JOY_SH/LDn   (5)
    ' P5 = JOY_DATAOUT0 (6)
    ' P6 = JOY_DATAOUT1 (7)
    ' NES Bit Encoding
     
    ' step 1: set I/Os
    DIRA [3] := 1 ' output
    DIRA [4] := 1 ' output
    DIRA [5] := 0 ' input
    DIRA [6] := 0 ' input
     
    ' step 2: set clock and latch to 0
    OUTA [3] := 0 ' JOY_CLK = 0
    OUTA [4] := 0 ' JOY_SH/LDn = 0
    'Delay(1)
     
    ' step 3: set latch to 1
    OUTA [4] := 1 ' JOY_SH/LDn = 1
    'Delay(1)
     
    ' step 4: set latch to 0
    OUTA [4] := 0 ' JOY_SH/LDn = 0
     
    ' step 5: read first bit of each game pad
     
    ' data is now ready to shift out
    ' first bit is ready
    nes_bits := 0
     
    ' left controller
    nes_bits := INA[5] | (INA[6] << 8)
     
    ' step 7: read next 7 bits
    repeat i from 0 to 6
         OUTA [3] := 1 ' JOY_CLK = 1
         'Delay(1)
         OUTA [3] := 0 ' JOY_CLK = 0
         nes_bits := (nes_bits << 1)
         nes_bits := nes_bits | INA[5] | (INA[6] << 8)
    if nes_bits
        'There's a gamepad
        ' invert bits to make positive logic
        nes_bits := (!nes_bits & $FFFF)
    'else
        'No gamepad plugged in, leave as zero.
    
DAT
' There seems to be some pointer leakage here.  Extra long as a patch.
                        long    0
' Hub scanline buffer = 256 pixels, 8 bits per pixel = 2048 bits = 256 bytes = 64 longs
hub_scanline_buffer
colorbar0               long    $0b_0b_0b_0b
colorbar1               long    $0c_0c_0c_0c
colorbar2               long    $0d_0d_0d_0d
colorbar3               long    $0e_0e_0e_0e
colorbar4               long    $1b_0b_1b_1b
colorbar5               long    $1c_0c_1c_1c
colorbar6               long    $1d_0d_1d_1d
colorbar7               long    $1e_0e_1e_1e
colorbar8               long    $2b_0b_2b_2b
colorbar9               long    $2c_2c_2c_2c
colorbar10              long    $2d_2d_2d_2d
colorbar11              long    $2e_2e_2e_2e
colorbar12              long    $3b_3b_3b_3b
colorbar13              long    $3c_3c_3c_3c
colorbar14              long    $3d_3d_3d_3d
colorbar15              long    $3e_3e_3e_3e
colorbar16              long    $4b_4b_4b_4b
colorbar17              long    $4c_4c_4c_4c
colorbar18              long    $4d_4d_4d_4d
colorbar19              long    $4e_4e_4e_4e
colorbar20              long    $5b_5b_5b_5b
colorbar21              long    $5c_5c_5c_5c
colorbar22              long    $5d_5d_5d_5d
colorbar23              long    $5e_5e_5e_5e
colorbar24              long    $6b_6b_6b_6b
colorbar25              long    $6c_6c_6c_6c
colorbar26              long    $6d_6d_6d_6d
colorbar27              long    $6e_6e_6e_6e
colorbar28              long    $7b_7b_7b_7b
colorbar29              long    $7c_7c_7c_7c
colorbar30              long    $7d_7d_7d_7d
colorbar31              long    $7e_7e_7e_7e
colorbar32              long    $8b_8b_8b_8b
colorbar33              long    $8c_8c_8c_8c
colorbar34              long    $8d_8d_8d_8d
colorbar35              long    $8e_8e_8e_8e
colorbar36              long    $9b_9b_9b_9b
colorbar37              long    $9c_9c_9c_9c
colorbar38              long    $9d_9d_9d_9d
colorbar39              long    $9e_9e_9e_9e
colorbar40              long    $ab_ab_ab_ab
colorbar41              long    $ac_ac_ac_ac
colorbar42              long    $ad_ad_ad_ad
colorbar43              long    $ae_ae_ae_ae
colorbar44              long    $bb_bb_bb_bb
colorbar45              long    $bc_bc_bc_bc
colorbar46              long    $bd_bd_bd_bd
colorbar47              long    $be_be_be_be
colorbar48              long    $cb_cb_cb_cb
colorbar49              long    $cc_cc_cc_cc
colorbar50              long    $cd_cd_cd_cd
colorbar51              long    $ce_ce_ce_ce
colorbar52              long    $db_db_db_db
colorbar53              long    $dc_dc_dc_dc
colorbar54              long    $dd_dd_dd_dd
colorbar55              long    $de_de_de_de
colorbar56              long    $eb_eb_eb_eb
colorbar57              long    $ec_ec_ec_ec
colorbar58              long    $ed_ed_ed_ed
colorbar59              long    $ee_ee_ee_ee
colorbar60              long    $fb_fb_fb_fb
colorbar61              long    $fc_fc_fc_fc
colorbar62              long    $fd_fd_fd_fd
colorbar63              long    $fe_fe_fe_fe
colorbar64              long    $0b_0b_0b_0b
colorbar65              long    $0c_0c_0c_0c
colorbar66              long    $0d_0d_0d_0d
colorbar67              long    $0e_0e_0e_0e
colorbar68              long    $1b_0b_1b_1b
colorbar69              long    $1c_0c_1c_1c
colorbar70              long    $1d_0d_1d_1d
colorbar71              long    $1e_0e_1e_1e
colorbar72              long    $2b_0b_2b_2b
colorbar73              long    $2c_2c_2c_2c
colorbar74              long    $2d_2d_2d_2d
colorbar75              long    $2e_2e_2e_2e
colorbar76              long    $3b_3b_3b_3b
colorbar77              long    $3c_3c_3c_3c
colorbar78              long    $3d_3d_3d_3d
colorbar79              long    $3e_3e_3e_3e
colorbar80              long    $4b_4b_4b_4b

' End of scanline buffer

scanline_req            long    0

waddicors1              byte    128,129,130,131,132,133,134,0
waddicors2              byte    135,136,137,138,139,140,141,0
waddicors3              byte    142,143,144,145,146,147,148,0

                        
                        

 